<?php

namespace App\Http\Controllers\API;

use App\Models\CardType;
use App\Traits\ApiResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CardTypeController extends Controller
{
    use ApiResponse;

    public function index()
    {
        $data = CardType::orderBy('id', 'desc')->get();
        return response()->json(['success' => true, 'data' => $data], 200);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'course_certifying_body_id' => 'required|string|max:255',
        ]);

        $data = new CardType();
        $data->name = $request->name;
        $data->course_certifying_body_id = $request->course_certifying_body_id;
        $data->save();

        return $this->success($data, 'Data stored successfully!', 200);
    }

    public function update(Request $request)
    {
        $data = CardType::find($request->id);

        if (!$data) {
           return $this->error(null, 'Data not found', 404);
        }

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'course_certifying_body_id' => 'required|string|max:255',
        ]);

        $data->name = $request->name;
        $data->course_certifying_body_id = $request->course_certifying_body_id;
        $data->save();

        return $this->success($data, 'Data update successfully!', 200);
    }

    public function delete(Request $request)
    {
        $data = CardType::find($request->id);

        if (!$data) {
            return $this->error(null, 'Data not found', 404);
        }

        $data->delete();

        return $this->success($data, 'Data deleted successfully!', 200);
    }
}
