<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Country;
use App\Traits\ApiResponse;
use Illuminate\Http\Request;

class CountryController extends Controller
{
    use ApiResponse;

    public function get()
    {
        $country = Country::all();

        if ($country->isEmpty()) {
            return $this->error([], 'Country not found!', 200);
        }

        return $this->success($country, 'Country fetch successful!', 200);
    }
}
