<?php

namespace App\Http\Controllers\API;

use App\Traits\ApiResponse;
use Illuminate\Http\Request;
use App\Models\CourseAddonList;
use Illuminate\Validation\Rule;

use App\Http\Controllers\Controller;

class CourseAddonListController extends Controller
{
    use ApiResponse;

    public function index()
    {
        $data = CourseAddonList::orderBy('id', 'desc')->get();
        return response()->json(['success' => true, 'data' => $data], 200);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'product_code' => 'required|string|max:255',
            'description' => 'required|string|max:65535',
            'display_order' => 'required|integer',
            'type' => 'nullable|integer',
            'price' => 'nullable|numeric|min:0',
        ]);

        $data = new CourseAddonList();
        $data->name = $request->name;
        $data->product_code = $request->product_code;
        $data->description = $request->description;
        $data->display_order = $request->display_order;
        $data->type = $request->type;
        $data->price = $request->price;
        $data->save();

        return $this->success($data, 'Data stored successfully!', 200);
    }

    public function update(Request $request)
    {
        $data = CourseAddonList::find($request->id);

        if (!$data) {
           return $this->error(null, 'Data not found', 404);
        }

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'product_code' => ['required', 'string', 'max:255',
                Rule::unique('course_addon_lists', 'product_code')->ignore($request->id),
            ],
            'description' => 'required|string|max:65535',
            'display_order' => 'required|integer',
            'type' => 'nullable|integer',
            'price' => 'nullable|numeric|min:0',
        ]);

        $data->name = $request->name;
        $data->product_code = $request->product_code;
        $data->description = $request->description;
        $data->display_order = $request->display_order;
        $data->type = $request->type;
        $data->price = $request->price;
        $data->save();

        return $this->success($data, 'Data update successfully!', 200);
    }

    public function delete(Request $request)
    {
        $data = CourseAddonList::find($request->id);

        if (!$data) {
            return $this->error(null, 'Data not found', 404);
        }

        $data->delete();
        return $this->success($data, 'Data deleted successfully!', 200);
    }
}
