<?php

namespace App\Http\Controllers\API;

use App\Traits\ApiResponse;
use Illuminate\Http\Request;
use App\Models\CourseCertifyingBody;
use App\Http\Controllers\Controller;

class CourseCertifyingBodyController extends Controller
{
    use ApiResponse;

    public function index()
    {
        $data = CourseCertifyingBody::orderBy('id', 'desc')->get();
        return $this->success($data, 'Data retrieved successfully!', 200);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
        ]);

        $data = new CourseCertifyingBody();
        $data->name = $request->name;
        $data->save();

        return $this->success($data, 'Data stored successfully!', 200);
    }

    public function update(Request $request)
    {
        $data = CourseCertifyingBody::find($request->id);

        if (!$data) {
           return $this->error(null, 'Data not found', 404);
        }

        $validated = $request->validate([
            'name' => 'required|string|max:255',
        ]);

        $data->name = $request->name;
        $data->save();

        return $this->success($data, 'Data update successfully!', 200);
    }

    public function delete(Request $request)
    {
        $data = CourseCertifyingBody::find($request->id);

        if (!$data) {
            return $this->error(null, 'Data not found', 404);
        }

        $data->delete();

        return $this->success($data, 'Data deleted successfully!', 200);
    }

}
