<?php

namespace App\Http\Controllers\API;

use App\Models\CourseImage;
use App\Traits\ApiResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CourseImageController extends Controller
{
    use ApiResponse;

    public function index()
    {
        $data = CourseImage::orderBy('id', 'desc')->get();
        return response()->json(['success' => true, 'data' => $data], 200);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'image' => 'required|image|mimes:jpg,jpeg,png,webp|max:2048',
            'image_type' => 'required|string|max:255',
            'course_id' => 'required|string|max:255',
        ]);

        $uploadPath = public_path('uploads/course');

        if (!file_exists($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $imageName = time().'_'.$request->image->getClientOriginalName();
        $request->image->move($uploadPath, $imageName);

        $data = new CourseImage();
        $data->image = $imageName;
        $data->image_type = $request->image_type;
        $data->course_id = $request->course_id;
        $data->save();

        return $this->success($data, 'Data stored successfully!', 200);

    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'image' => 'nullable|image|mimes:jpg,jpeg,png,webp|max:2048',
            'image_type' => 'required|string|max:255',
            'course_id' => 'required|string|max:255',
        ]);

        $data = CourseImage::findOrFail($request->id);
        $uploadPath = public_path('uploads/course');

        if (!file_exists($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        if ($request->hasFile('image')) {

            if ($data->image && file_exists($uploadPath.'/'.$data->image)) {
                unlink($uploadPath.'/'.$data->image);
            }

            $imageName = time().'_'.$request->image->getClientOriginalName();
            $request->image->move($uploadPath, $imageName);
            $data->image = $imageName;
        }

        $data->image_type = $request->image_type;
        $data->course_id = $request->course_id;
        $data->save();

        return $this->success($data, 'Data updated successfully!', 200);
    }

    public function delete(Request $request)
    {
        $data = CourseImage::findOrFail($request->id);

        if (!$data) {
           return $this->error(null, 'Data not found', 404);
        }

        $uploadPath = public_path('uploads/course');

        if ($data->image && file_exists($uploadPath.'/'.$data->image)) {
            unlink($uploadPath.'/'.$data->image);
        }

        $data->delete();

        return $this->success($data, 'Data deleted successfully!', 200);
    }

}
