<?php

namespace App\Http\Controllers\API;

use App\Traits\ApiResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\InstructorCertifications;

class InstructorCertificationsController extends Controller
{
    use ApiResponse;

    // Get All Certifications
    public function index()
    {
        $certification = InstructorCertifications::orderBy('id', 'asc')->get();
        $certification->load('discipline');

        return $this->success($certification, "Data Retrieved Successfully", 200);
    }

    // Get Single Certification
    public function show(Request $request)
    {
        $certification = InstructorCertifications::find($request->id);
        $certification->load('discipline');

        return $this->success($certification, "Data Retrieved Successfully", 200);
    }

    // Create Certification
    public function store(Request $request)
    {
        $request->validate([
            'discipline_id' => 'required|exists:instructor_discipline,id',
            'initial'       => 'required|date',
            'expires'       => 'required|date|after_or_equal:initial',
        ]);

        $certification = InstructorCertifications::create([
            'discipline_id' => $request->discipline_id,
            'initial'       => $request->initial,
            'expires'       => $request->expires,
        ]);

        $certification->load('discipline');
        return $this->success($certification, 'Data stored successfully!', 200);
    }

    // Update Certification
    public function update(Request $request)
    {
        $certification = InstructorCertifications::find($request->id);

        if (!$certification) {
           return $this->error(null, 'Data not found', 404);
        }

        $request->validate([
            'discipline_id' => 'required|exists:instructor_discipline,id',
            'initial'       => 'required|date',
            'expires'       => 'required|date|after_or_equal:initial',
        ]);

        $certification->update([
            'discipline_id' => $request->discipline_id,
            'initial'       => $request->initial,
            'expires'       => $request->expires,
        ]);

        $certification->load('discipline');
        return $this->success($certification, 'Data update successfully!', 200);
    }

    // Delete Certification
    public function destroy(Request $request)
    {
        $certification = InstructorCertifications::find($request->id);

        if (!$certification) {
            return $this->error(null, 'Data not found', 404);
        }

        $certification->delete();
        $certification->load('discipline');
        
        return $this->success($certification, 'Data deleted successfully!', 200);
    }

}
