<?php

namespace App\Http\Controllers\API;

use App\Models\Discipline;
use App\Traits\ApiResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class InstructorDisciplineController extends Controller
{
    use ApiResponse;

    // Get All Disciplines
    public function index()
    {
        $discipline = Discipline::orderBy('id', 'asc')->get();
        return $this->success($discipline, "Data Retrieved Successfully", 200);
    }

    // Get Single Discipline
    public function show(Request $request)
    {
        $discipline = Discipline::find($request->id);
        return $this->success($discipline, "Data Retrieved Successfully", 200);
    }

    // Create Discipline
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255|unique:instructor_discipline,name',
        ]);

        $discipline = new Discipline();
        $discipline->name = $request->name;
        $discipline->save();

        return $this->success($discipline, 'Data stored successfully!', 200);
    }

    // Update Discipline
    public function update(Request $request)
    {
        $discipline = Discipline::find($request->id);

        if (!$discipline) {
           return $this->error(null, 'Data not found', 404);
        }

        $validated = $request->validate([
            'name' => 'required|string|max:255',
        ]);

        $discipline->name = $request->name;
        $discipline->save();

        return $this->success($discipline, 'Data update successfully!', 200);
    }

    // Delete Discipline
    public function destroy(Request $request)
    {
        $discipline = Discipline::find($request->id);

        if (!$discipline) {
            return $this->error(null, 'Data not found', 404);
        }

        $discipline->delete();
        return $this->success($discipline, 'Data deleted successfully!', 200);
    }

}
