<?php

namespace App\Http\Controllers\API;

use App\Traits\ApiResponse;
use Illuminate\Http\Request;
use App\Models\InstructorDocuments;
use App\Http\Controllers\Controller;

class InstructorDocumentsController extends Controller
{
    use ApiResponse;

    // Get All Documents
    public function index()
    {
        $documents = InstructorDocuments::orderBy('id', 'asc')->get();
        return $this->success($documents, "Data Retrieved Successfully", 200);
    }

    // Get Single Document
    public function show(Request $request)
    {
        $document = InstructorDocuments::find($request->id);
        return $this->success($document, "Data Retrieved Successfully", 200);
    }

    // Store Documents
    public function store(Request $request)
    {
        $validated = $request->validate([
            'instructor_id' => 'required|string|max:255',
            'document_path' => 'required|file|mimes:jpg,jpeg,png,webp,pdf,doc,docx|max:2048',
        ]);

        $uploadPath = public_path('uploads/documents');

        if (!file_exists($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $imageName = time().'_'.$request->document_path->getClientOriginalName();
        $request->document_path->move($uploadPath, $imageName);

        $document = new InstructorDocuments();
        $document->instructor_id = $request->instructor_id;
        $document->document_path = $imageName;
        $document->save();

        return $this->success($document, 'Data stored successfully!', 200);
    }

    // Update Document
    public function update(Request $request)
    {
        $document = InstructorDocuments::find($request->id);

        if (!$document) {
           return $this->error(null, 'Data not found', 404);
        }

        $uploadPath = public_path('uploads/documents');

        if (!file_exists($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $imageName = time().'_'.$request->document_path->getClientOriginalName();
        $request->document_path->move($uploadPath, $imageName);

        if (file_exists($uploadPath.'/'.$document->document_path)) {
            unlink($uploadPath.'/'.$document->document_path);
        }

        $document->instructor_id = $request->instructor_id;
        $document->document_path = $imageName;
        $document->save();

        return $this->success($document, 'Data update successfully!', 200);
    }

    // Delete Document
    public function destroy(Request $request)
    {
        $document = InstructorDocuments::find($request->id);

        if (!$document) {
            return $this->error(null, 'Data not found', 404);
        }

        $filePath = public_path('uploads/documents/' . $document->document_path);
        if (file_exists($filePath)) {
            unlink($filePath);
        }

        $document->delete();
        return $this->success($document, 'Data deleted successfully!', 200);
    }

}