<?php

namespace App\Http\Controllers\API;

use App\Models\Instructor;
use App\Traits\ApiResponse;
use App\Models\TrainingSite;
use Illuminate\Http\Request;
use App\Models\InstructorInfo;
use App\Http\Controllers\Controller;

class InstructorInfoController extends Controller
{
    use ApiResponse;

    // Get Single Instructor Info
    public function show(Request $request)
    {
        $InstructorInfo = InstructorInfo::find($request->id);
        return $this->success($InstructorInfo, "Data Retrieved Successfully", 200);
    }
    // Create Role
    public function update(Request $request)
    {
        $request->validate([
            'instructor_id'  => 'required|exists:instructors,id',
            'monitor_date'   => 'nullable|date',
            'dues_paid_thru' => 'nullable|date',
            'notes'          => 'nullable|string',
        ]);

        $instructor = Instructor::findOrFail($request->instructor_id);
        $basicInfo = InstructorInfo::create([
            'instructor_id' => $instructor->id,
            'training_site' => $instructor->trainingSite->company_name,

            'contact_info' => [
                'email'            => $instructor->email,
                'first_name'       => $instructor->first_name,
                'last_name'        => $instructor->last_name,
                'mobile_phone'     => $instructor->mobile_phone,
                'address_line_1'   => $instructor->address_line_1,
                'address_line_2'   => $instructor->address_line_2,
                'aha_instructor_id'=> $instructor->aha_instructor_id,
            ],

            'monitor_date'   => $request->monitor_date,
            'dues_paid_thru' => $request->dues_paid_thru,
            'notes'          => $request->notes,
        ]);

        $basicInfo = InstructorInfo::new();
        $basicInfo->instructor_id = $instructor->id;
        $basicInfo->training_site = $instructor->trainingSite->company_name;
        $basicInfo->contact_info  = [
            'email'             => $instructor['email'],
            'first_name'        => $instructor['first_name'],
            'last_name'         => $instructor['last_name'],
            'mobile_phone'      => $instructor['mobile_phone'],
            'address_line_1'    => $instructor['address_line_1'],
            'address_line_2'    => $instructor['address_line_2'],
            'aha_instructor_id' => $instructor['aha_instructor_id'],
        ];

        $basicInfo->monitor_date   = $request->monitor_date;
        $basicInfo->dues_paid_thru = $request->dues_paid_thru;
        $basicInfo->notes          = $request->notes;
        $basicInfo->save();

        return $this->success($basicInfo, 'Information update successfully!', 200);
    }

}
