<?php

namespace App\Http\Controllers\API;

use App\Models\KeycodeBank;
use App\Traits\ApiResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class KeyCodeBankController extends Controller
{
    use ApiResponse;
    
    public function index()
    {
        $data = KeycodeBank::orderBy('id', 'desc')->get();
        return response()->json(['success' => true, 'data' => $data], 200);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name'         => 'required|string|max:255',
            'instructions' => 'required|string|max:255',
            'course_link'  => 'nullable|string|max:255',
        ]);

        $keycodeBank = KeycodeBank::create($validated);
        return $this->success($keycodeBank, 'Keycode stored successfully!', 200);
    }

    public function update(Request $request)
    {
        $keycodeBank = KeycodeBank::find($request->id);

        if (!$keycodeBank) {
            return $this->error(null, 'Data not found', 404);
        }

        $validated = $request->validate([
            'name'         => 'required|string|max:255',
            'instructions' => 'required|string',
            'course_link'  => 'nullable|string|max:255',
        ]);

        $keycodeBank->update($validated);
        return $this->success($keycodeBank, 'Keycode updated successfully!', 200);
    }

    public function delete(Request $request)
    {
        $keycodeBank = KeycodeBank::find($request->id);

        if (!$keycodeBank) {
            return $this->error(null, 'Keycode not found', 404);
        }

        $keycodeBank->delete();

        return $this->success($keycodeBank, 'Keycode deleted successfully!', 200);
    }
}
