<?php

namespace App\Http\Controllers\API;

use App\Models\Role;
use App\Traits\ApiResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class RoleController extends Controller
{
    use ApiResponse;

    // Get All Roles
    public function index()
    {
        $role = Role::orderBy('id', 'asc')->get();
        return $this->success($role, "Data Retrieved Successfully", 200);
    }

    // Get Single Role
    public function show(Request $request)
    {
        $role = Role::find($request->id);
        return $this->success($role, "Data Retrieved Successfully", 200);
    }

    // Create Role
    public function store(Request $request)
    {
        $validated = $request->validate([
            'role_name' => 'required|string|max:255',
        ]);

        $role = new Role();
        $role->role_name = $request->role_name;
        $role->save();

        return $this->success($role, 'Data stored successfully!', 200);
    }

    // Update Role
    public function update(Request $request)
    {
        $role = Role::find($request->id);

        if (!$role) {
           return $this->error(null, 'Data not found', 404);
        }

        $validated = $request->validate([
            'role_name' => 'required|string|max:255',
        ]);

        $role->role_name = $request->role_name;
        $role->save();

        return $this->success($role, 'Data update successfully!', 200);
    }

    // Delete Role
    public function destroy(Request $request)
    {
        $role = Role::find($request->id);

        if (!$role) {
            return $this->error(null, 'Data not found', 404);
        }

        $role->delete();

        return $this->success($role, 'Data deleted successfully!', 200);
    }

}

