<?php

namespace App\Http\Controllers\API;

use App\Traits\ApiResponse;
use App\Models\TextMessages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TextMessagesController extends Controller
{
    use ApiResponse;

    public function updateFromJson(Request $request)
    {
        $request->validate([
            'id' => 'required|exists:scheduled_text_messages,id',
            'message_settings' => 'required|array',
        ]);

        $message = TextMessages::find($request->id);

        $message->update([
            'message_settings' => $request->message_settings,
        ]);

        return $this->success($message->message_settings, 'Data update successfully!', 200);
    }

    public function updateFromTable(Request $request)
    {
        $request->validate([
            'id' => 'required|exists:scheduled_text_messages,id',
            'day_offset' => 'required|integer',
            'name' => 'required|string',
            'message' => 'required|string',
            'active' => 'required|boolean',
        ]);

        $message = TextMessages::find($request->id);

        $message->update([
            'day_offset' => $request->day_offset,
            'name' => $request->name,
            'message' => $request->message,
            'active' => $request->active,
        ]);

        return $this->success($message, 'Data update successfully!', 200);
    }

}
