<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Course extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];    

    public function addons()
    {
        return $this->belongsToMany(
            CourseAddonList::class,'selected_course_addons', 'course_id', 'addon_id'
        );
    }

    public function deposits()
    {
        return $this->hasMany(DepositAmount::class, 'course_id');
    }
    
    public function restrictedPromoCodes()
    {
        return $this->belongsToMany(
            PromoCode::class, 'promo_code_restrict_courses', 'course_id', 'promo_code_id'
        );
    }
}
