<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Instructor extends Authenticatable
{
    use HasFactory;
    protected $guarded = [];
    protected $casts = [
        'roles' => 'array',
        'active_user' => 'boolean',
        'read_only_user' => 'boolean',
        'allow_bid_on_open_classes' => 'boolean',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    // Relationship to Training Site
    public function trainingSite()
    {
        return $this->belongsTo(TrainingSite::class);
    }

    public function roles()
    {
        return $this->belongsToMany(Role::class, 'user_role', 'instructor_id', 'role_id');
    }

    public function basicInfo()
    {
        return $this->hasOne(InstructorInfo::class);
    }
}
