<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class InstructorInfo extends Model
{
    use HasFactory;
    protected $guarded = ['id'];
    
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected $table = 'instructor_basic_info';

    protected $fillable = [
        'instructor_id',
        'contact_info',
        'training_site',
        'monitor_date',
        'dues_paid_thru',
        'notes',
    ];

    protected $casts = [
        'contact_info' => 'array',
        'monitor_date' => 'date',
        'dues_paid_thru' => 'date',
    ];

    public function instructor()
    {
        return $this->belongsTo(Instructor::class);
    }
}
