<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PromoCode extends Model
{
    protected $guarded = ['id'];

    protected $table = 'promo_code';

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function restrictCourses()
    {
        return $this->belongsToMany(
            Course::class, 'promo_code_restrict_courses', 'promo_code_id', 'course_id'
        );
    }

}
