<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('training_sites', function (Blueprint $table) {
            $table->id();
            $table->string('company_name');
            $table->string('training_center_name');
            $table->string('contact_first_name');
            $table->string('contact_last_name');
            $table->string('email')->unique();
            $table->string('phone_number');
            $table->string('fax_number')->nullable();
            $table->string('address_line_1');
            $table->string('address_line_2')->nullable();
            $table->string('city');
            $table->string('state_province');
            $table->string('postal_code');
            $table->string('country');
            $table->string('training_site_id')->nullable();
            $table->bigInteger('price_level')->default(0);
            $table->bigInteger('sales_tax_rate')->default(0);
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('training_sites');
    }
};
