<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('training_site_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('training_site_id')->constrained('training_sites')->onDelete('cascade');
            $table->boolean('enable_certification_card_printing')->default(false);
            $table->boolean('send_reminders_to_instructors_with_unfinalized_rosters')->default(false);
            $table->boolean('create_an_admin_user_for_this_site')->default(false);
            $table->boolean('restrict_tc_product_orders_to_admins_only')->default(false);
            $table->boolean('restrict_instructors_to_only_view_classes_they_teach')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('training_site_settings');
    }
};
