<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('instructors', function (Blueprint $table) {
            $table->id();
            // Basic Info
            $table->string('username')->unique();
            $table->unsignedBigInteger('training_site_id');

            $table->string('first_name');
            $table->string('middle_name')->nullable();
            $table->string('last_name');

            $table->string('address_line_1');
            $table->string('address_line_2')->nullable();
            $table->string('city');
            $table->string('state_province_region');
            $table->string('zip_postal_code');
            $table->unsignedBigInteger('country_id');
            $table->string('mobile_phone')->nullable();

            // Instructor IDs
            $table->string('name_to_print_on_card')->nullable();
            $table->string('aha_instructor_id')->nullable();
            $table->string('hsi_instructor_id')->nullable();
            $table->string('rclc_username')->nullable();

            // Login
            $table->string('email')->unique();
            $table->string('password');

            // Options
            $table->boolean('active_user')->default(true);
            $table->boolean('read_only_user')->default(false);
            $table->boolean('allow_bid_on_open_classes')->default(false);

            // Roles stored as JSON
            $table->timestamps();
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('instructors');
    }
};
