<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('keycode_banks', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('instructions');
            $table->string('course_link');
            $table->enum('status', ['1', '2'])->default('2')->comment('1=Active, 2=Inactive');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('keycode_banks');
    }
};
