<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->id();

            $table->string('company');
            $table->string('abbreviation')->nullable();

            $table->string('contact_first_name')->nullable();
            $table->string('contact_last_name')->nullable();
            $table->string('email')->nullable();

            $table->date('contact_date')->nullable();

            $table->string('website')->nullable();

            $table->string('main_phone')->nullable();
            $table->string('mobile_phone')->nullable();
            $table->string('fax')->nullable();

            $table->foreignId('location_id')->nullable()->constrained()->nullOnDelete();

            $table->string('address_1')->nullable();
            $table->string('address_2')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('zip')->nullable();

            $table->foreignId('country_id')->nullable()->constrained()->nullOnDelete();

            $table->string('cc_confirmations_to')->nullable();

            $table->text('shared_notes')->nullable();
            $table->text('internal_notes')->nullable();

            $table->timestamps();
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clients');
    }
};
