<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();
            $table->string('course_name');
            $table->tinyInteger('mode');
            $table->tinyInteger('discipline');
            $table->decimal('allow_deposit', 10, 2);
            $table->text('prompt');
            $table->float('shipping_price');
            $table->foreignId('keycode_bank_id')->nullable()->constrained('keycode_banks')->cascadeOnDelete();
            $table->foreignId('card_type_id')->nullable()->constrained('card_types')->cascadeOnDelete();
            $table->foreignId('second_card_type_id')->nullable()->constrained('second_card_types')->cascadeOnDelete();
            $table->string('calendar_icon_color')->nullable();
            $table->string('ecu_credits')->nullable();
            $table->longText('description')->nullable();
            $table->boolean('custom_sidebar')->default(false);
            $table->string('confirmation_email')->nullable();
            $table->string('email_subject')->nullable();
            $table->string('payment_confirmation_email')->nullable();
            $table->longText('email_body')->nullable();
            $table->tinyInteger('seo_rich_results')->default(0);
            $table->tinyInteger('seo_description')->default(0);
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('courses');
    }
};
