<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scheduled_text_messages', function (Blueprint $table) {
            $table->id();
            $table->integer('day_offset');
            $table->string('timing');
            $table->string('name');
            $table->text('message');
            $table->json('message_settings');
            $table->boolean('active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scheduled_text_messages');
    }
};
