<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class ScheduledTextMessageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $messages = [
            [
                'day_offset' => -5,
                'timing' => '5 days before class',
                'name' => 'Test Message',
                'message' => "Hi [FIRSTNAME], This is from Code Blue CPR Services, LLC. Your CPR class is coming up soon! 📅 [CLASSINFO] Please arrive 10-15 minutes early and bring a valid photo ID. If you have any questions or need to reschedule, please let us know as soon as possible. Rescheduling within 2 business days may be subject to a reschedule fee. We're excited to have you in class! If you need immediate assistance, call Nathan at 352-901-0007. Visit www.codebluecprservices.com 💙❤️",
                'active' => true,
                'message_settings' =>json_encode([
                    'phone' => '123456789',
                    'reply_text' => 'Thanks for signing up for your CPR Course. Please Call Us Directly if you have any questions at 123456789',
                    'forward_email' => 'Training@Shellcpr.com',
                ])
            ],
            [
                'day_offset' => -3,
                'timing' => '3 days before class',
                'name' => 'Test Message',
                'message' => "Hi [FIRSTNAME], This is from Shell CPR and Code Blue CPR Services, LLC. Your CPR class is coming up soon! 📅 [CLASSINFO] Please arrive 10-15 minutes early and bring a valid photo ID. If you have any questions or need to reschedule, please let us know as soon as possible. Rescheduling within 2 business days may be subject to a reschedule fee. We're excited to have you in class! If you need immediate assistance, call Nathan at 352-901-0007. Visit www.codebluecprservices.com 💙❤️",
                'active' => true,
                'message_settings' =>json_encode([
                    'phone' => '123456789',
                    'reply_text' => 'Thanks for signing up for your CPR Course. Please Call Us Directly if you have any questions at 123456789',
                    'forward_email' => 'Training@Shellcpr.com',
                ])
            ],
            [
                'day_offset' => -1,
                'timing' => 'Class Information',
                'name' => 'Test Message',
                'message' => "Hi [FIRSTNAME], This is from Code Blue CPR Services, LLC. Just a friendly reminder about your upcoming CPR class! 📅 [CLASSINFO] Please arrive 10-15 minutes early and bring a valid photo ID if over the age of 16. If you have any questions or need to reschedule, please reach out. Rescheduling within 2 business days may be subject to a reschedule fee. We look forward to seeing you in class! For immediate support, call Nathan at 352-901-0007. Visit www.codebluecprservices.com 💙❤️",
                'active' => true,
                'message_settings' =>json_encode([
                    'phone' => '123456789',
                    'reply_text' => 'Thanks for signing up for your CPR Course. Please Call Us Directly if you have any questions at 123456789',
                    'forward_email' => 'Training@Shellcpr.com',
                ])
            ],
            [
                'day_offset' => 1,
                'timing' => 'Follow-up after class',
                'name' => 'Test Message',
                'message' => "Hi [FIRSTNAME], Code Blue CPR Services, LLC. would like to Thank you for attending the CPR Class! We appreciate you taking the time to learn these lifesaving skills—your dedication truly makes a difference! We'd love to hear your feedback on your experience. Let us know we did or if you have any questions. You can reply to this message. We also love referrals! If you know anyone who needs CPR training, please share our information: www.codebluecprservices.com. Thanks again, and we hope to see you in a future class! 💙❤️ Code Blue CPR Services, LLC 689-500-7044 Office",
                'active' => true,
                'message_settings' =>json_encode([
                    'phone' => '123456789',
                    'reply_text' => 'Thanks for signing up for your CPR Course. Please Call Us Directly if you have any questions at 123456789',
                    'forward_email' => 'Training@Shellcpr.com',
                ])
            ],
        ];

        foreach ($messages as $msg) {
            DB::table('scheduled_text_messages')->updateOrInsert(
                ['day_offset' => $msg['day_offset']],
                $msg
            );
        }
    }
}
