<?php

namespace Database\Seeders;

use App\Models\TrainingSite;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TrainingSiteSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $sites = [
            [
                'company_name' => 'AHA SHELL CPR, LLC 615-230-7991',
                'training_center_name' => 'SHELL CPR, LLC TRAINING CENTER',
                'contact_first_name' => 'NATHANIEL',
                'contact_last_name' => 'SHELL',
                'email' => 'TRAINING@SHELLCPR.COM',
                'phone_number' => '615-230-7991',
                'fax_number' => null,
                'address_line_1' => '640 SPENCE LANE',
                'address_line_2' => 'STE 125',
                'city' => 'NASHVILLE',
                'state_province' => 'TN',
                'postal_code' => '37217',
                'country' => 'United States',
                'training_site_id' => 'TS-100',
                'price_level' => 7,
                'sales_tax_rate' => 0,
                'notes' => 'Primary training site.',
            ],
            [
                'company_name' => 'AMERICAN HEART ASSOCIATION - CODE BLUE CPR SERVICES',
                'training_center_name' => 'CODE BLUE CPR SERVICES TRAINING CENTER',
                'contact_first_name' => 'NATHANIEL',
                'contact_last_name' => 'SHELL',
                'email' => 'NATHAN@CODEBLUECPRSERVICES.COM',
                'phone_number' => '3529010007',
                'fax_number' => null,
                'address_line_1' => '640 SPENCE LANE',
                'address_line_2' => 'STE 125',
                'city' => 'NASHVILLE',
                'state_province' => 'TN',
                'postal_code' => '37217',
                'country' => 'United States',
                'training_site_id' => null,
                'price_level' => 7,
                'sales_tax_rate' => 0,
                'notes' => 'Secondary site used for weekend classes.',
            ],
        ];

        foreach ($sites as $site) {
            $siteId = DB::table('training_sites')->insertGetId([
                ...$site,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            // Insert related settings
            DB::table('training_site_settings')->insert([
                'training_site_id' => $siteId,
                'enable_certification_card_printing' => 1,
                'send_reminders_to_instructors_with_unfinalized_rosters' => 1,
                'create_an_admin_user_for_this_site' => 0,
                'restrict_tc_product_orders_to_admins_only' => 0,
                'restrict_instructors_to_only_view_classes_they_teach' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
