@extends('backend.app')
@section('title', 'Edit Blog')

@section('content')
<div class="page-body">
    <div class="mt-4 card card-body">
        <div>
            <h4 class="mb-4">Edit Blog</h4>
        </div>
        <form action="{{ route('admin.blogs.update', $blog) }}" method="POST" enctype="multipart/form-data">
            @csrf @method('PUT')
            <div class="mb-3">
                <label>Title</label>
                <input type="text" name="title" class="form-control" value="{{ $blog->title }}">
            </div>
            <div class="mb-3">
                <label>Content</label>
                <textarea name="content" class="form-control" rows="5">{{ $blog->content }}</textarea>
            </div>
            <div class="mb-3">
                <label>Image</label>
                <input type="file" name="image" class="form-control">
                @if ($blog->image)
                <img src="{{ asset('storage/' . $blog->image) }}" width="100" class="mt-2">
                @endif
            </div>
            <div class="mb-3">
                <label>Status</label>
                <select name="status" class="form-control">
                    <option value="draft" {{ $blog->status == 'draft' ? 'selected' : '' }}>Draft</option>
                    <option value="published" {{ $blog->status == 'published' ? 'selected' : '' }}>Published</option>
                </select>
            </div>
            <button type="submit" class="btn btn-success">Update</button>
        </form>
    </div>
</div>
@endsection