<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\RoleController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\BlogController;
use App\Http\Controllers\Api\ClientController;
use App\Http\Controllers\Api\CountryController;
use App\Http\Controllers\Api\LocationController;
use App\Http\Controllers\Api\PromoCodeController;
use App\Http\Controllers\Api\InstructorController;
use App\Http\Controllers\Api\Auth\LoginController;
use App\Http\Controllers\Api\SocialMediaController;
use App\Http\Controllers\Api\TrainingSiteController;
use App\Http\Controllers\Api\Auth\RegisterController;
use App\Http\Controllers\Api\SystemSettingController;
use App\Http\Controllers\Api\InstructorInfoController;
use App\Http\Controllers\Api\InstructorDocumentsController;
use App\Http\Controllers\Api\InstructorDisciplineController;
use App\Http\Controllers\Api\InstructorCertificationsController;

//Register API
Route::controller(RegisterController::class)->prefix('users/register')->group(function () {
    // User Register
    Route::post('/', 'userRegister');

    // Verify OTP
    Route::post('/otp-verify', 'otpVerify');

    // Resend OTP
    Route::post('/otp-resend', 'otpResend');
});

//Login API
Route::controller(LoginController::class)->prefix('users/login')->group(function () {

    // User Login
    Route::post('/', 'userLogin');

    // Verify Email
    Route::post('/email-verify', 'emailVerify');

    // Resend OTP
    Route::post('/otp-resend', 'otpResend');

    // Verify OTP
    Route::post('/otp-verify', 'otpVerify');

    //Reset Password
    Route::post('/reset-password', 'resetPassword');
});

//Country APIs
Route::controller(CountryController::class)->group(function () {
    Route::get('/country', 'get');
});

Route::group(['middleware' => ['auth:sanctum']], function () {

    Route::controller(UserController::class)->prefix('users')->group(function () {
        Route::post('/', 'AllUsers');
        Route::get('/data', 'userData');
        Route::post('/data/update', 'userUpdate');
        Route::post('/logout', 'logoutUser');
        Route::delete('/delete', 'deleteUser');
    });

    Route::controller(SystemSettingController::class)->group(function () {
        Route::get('/site-settings', 'index');
    });

    Route::controller(SocialMediaController::class)->group(function () {
        Route::get('/social-links', 'index');
    });

    Route::controller(BlogController::class)->group(function () {
        Route::get('/blogs', 'index');
    });

    Route::controller(TrainingSiteController::class)->group(function () {
        Route::get('/training-sites', 'getTrainingSites');
        Route::get('/training-site/edit/{id}', 'editTrainingSite');
        Route::post('/training-site/create', 'getTrainingSiteCreate');
        Route::post('/training-site/update/{id}', 'updateTrainingSite');
    });

    Route::controller(InstructorController::class)->group(function () {
        Route::get('/instructors', 'index');
        Route::get('/instructors/{id}', 'show');
        Route::post('/instructors/store', 'store');
        Route::post('/instructors/{id}/update', 'update');
        Route::delete('/instructors/{id}', 'destroy');
    });

    Route::controller(RoleController::class)->prefix('roles')->group(function () {
        Route::get('/show', 'show');
        Route::get('/index', 'index');
        Route::post('/store', 'store');
        Route::post('/update', 'update');
        Route::delete('/delete', 'destroy');
    });

    Route::controller(InstructorInfoController::class)->prefix('instructor-info')->group(function () {
        Route::get('/show', 'show');
        Route::post('/update', 'update');
    });

    Route::controller(InstructorDisciplineController::class)->prefix('discipline')->group(function () {
        Route::get('/show', 'show');
        Route::get('/index', 'index');
        Route::post('/store', 'store');
        Route::post('/update', 'update');
        Route::delete('/delete', 'destroy');
    });

    Route::controller(InstructorCertificationsController::class)->prefix('certifications')->group(function () {
        Route::get('/show', 'show');
        Route::get('/index', 'index');
        Route::post('/store', 'store');
        Route::post('/update', 'update');
        Route::delete('/delete', 'destroy');
    });

    Route::controller(InstructorDocumentsController::class)->prefix('documents')->group(function () {
        Route::get('/show', 'show');
        Route::get('/index', 'index');
        Route::post('/store', 'store');
        Route::post('/update', 'update');
        Route::delete('/delete', 'destroy');
    });

    // Promo Code APIs
    Route::controller(PromoCodeController::class)->prefix('promo-codes')->group(function () {
        Route::get('/show', 'show');
        Route::get('/index', 'index');
        Route::post('/store', 'store');
        Route::post('/update', 'update');
        Route::delete('/delete', 'destroy');
    });

    Route::controller(LocationController::class)->prefix('locations')->group(function () {
        Route::get('/', 'index');
        Route::get('/{id}', 'show');
        Route::post('/store', 'store');
        Route::post('/{id}/update', 'update');
        Route::delete('/{id}', 'destroy');
    });
    
    Route::controller(ClientController::class)->prefix('clients')->group(function () {
        Route::get('/', 'index');
        Route::get('/{id}', 'show');
        Route::post('/store', 'store');
        Route::post('/{id}/update', 'update');
        Route::delete('/{id}', 'destroy');
    });

});