<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\CourseController;
use App\Http\Controllers\API\CardTypeController;
use App\Http\Controllers\API\KeyCodeBankController;
use App\Http\Controllers\API\CourseImageController;
use App\Http\Controllers\API\TextMessagesController;
use App\Http\Controllers\API\SecondCardTypeController;
use App\Http\Controllers\API\CourseAddonListController;
use App\Http\Controllers\API\CourseCertifyingBodyController;

Route::group(['middleware' => ['auth:sanctum']], function () {

    Route::controller(KeyCodeBankController::class)->group(function () {
        Route::get('/kcb/index', 'index');
        Route::post('/keycode-bank/store', 'store');
        Route::post('/keycode-bank/update', 'update');
        Route::delete('/keycode-bank/delete', 'delete');
    });

    Route::controller(CourseCertifyingBodyController::class)->group(function () {
        Route::get('/csb/index', 'index');
        Route::post('/course_cb/store', 'store');
        Route::post('/course_cb/update', 'update');
        Route::delete('/course_cb/delete', 'delete');
    });

    Route::controller(CardTypeController::class)->group(function () {
        Route::get('/card/index', 'index');
        Route::post('/card/store', 'store');
        Route::post('/card/update', 'update');
        Route::delete('/card/delete', 'delete');
    });

    Route::controller(SecondCardTypeController::class)->group(function () {
        Route::get('/second_card/index', 'index');
        Route::post('/second_card/store', 'store');
        Route::post('/second_card/update', 'update');
        Route::delete('/second_card/delete', 'delete');
    });

    Route::controller(CourseImageController::class)->group(function () {
        Route::get('/coursr_image/index', 'index');
        Route::post('/coursr_image/store', 'store');
        Route::post('/coursr_image/update', 'update');
        Route::delete('/coursr_image/delete', 'delete');
    });

    Route::controller(CourseAddonListController::class)->group(function () {
        Route::get('/addon_list/index', 'index');
        Route::post('/addon_list/store', 'store');
        Route::post('/addon_list/update', 'update');
        Route::delete('/addon_list/delete', 'delete');
    });

    Route::controller(CourseController::class)->group(function () {
        Route::get('/couese/index', 'index');
        Route::post('/couese/store', 'store');
        Route::post('/couese/update', 'update');
        Route::delete('/couese/delete', 'delete');
    });

    Route::controller(TextMessagesController::class)->group(function () {
        Route::post('/text-message/json-update', 'updateFromJson');
        Route::post('/text-message/table-update', 'updateFromTable');
    });
    
});