<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Admin Panel</title>

    <?php echo $__env->make('backend.partials.style', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        /* 🌈 Animated Gradient Background */
        body {
            height: 100vh;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: 'Segoe UI', sans-serif;
            color: #fff;
            background: linear-gradient(-45deg, #6366f1, #8b5cf6, #06b6d4, #3b82f6);
            background-size: 400% 400%;
            animation: gradientBG 12s ease infinite;
            overflow: hidden;
        }

        @keyframes gradientBG {
            0% {
                background-position: 0% 50%;
            }

            50% {
                background-position: 100% 50%;
            }

            100% {
                background-position: 0% 50%;
            }
        }

        /* ✨ Floating Blur Shapes */
        .shape {
            position: absolute;
            border-radius: 50%;
            filter: blur(80px);
            opacity: 0.5;
            animation: float 10s infinite ease-in-out;
        }

        .shape.one {
            width: 300px;
            height: 300px;
            background: #22d3ee;
            top: -100px;
            left: -100px;
        }

        .shape.two {
            width: 350px;
            height: 350px;
            background: #a78bfa;
            bottom: -120px;
            right: -120px;
            animation-delay: 3s;
        }

        @keyframes float {

            0%,
            100% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-40px);
            }
        }

        /* 🧊 Glass Login Card */
        .login-card {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(20px);
            padding: 50px 40px;
            border-radius: 22px;
            width: 100%;
            max-width: 460px;
            box-shadow: 0 25px 60px rgba(0, 0, 0, 0.35);
            animation: fadeInUp 1s ease forwards;
            z-index: 2;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(40px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .login-card h3 {
            font-weight: 700;
            font-size: 1.9rem;
        }

        .login-card p {
            opacity: 0.9;
        }

        /* 📝 Inputs */
        .input-group-text {
            background: rgba(255, 255, 255, 0.25);
            border: none;
            color: #fff;
            border-radius: 12px 0 0 12px;
        }

        .form-control {
            background: rgba(255, 255, 255, 0.25);
            border: none;
            color: #fff;
            padding: 13px 15px;
            border-radius: 0 12px 12px 0;
        }

        .form-control::placeholder {
            color: rgba(255, 255, 255, 0.7);
        }

        .form-control:focus {
            box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.5);
            background: rgba(255, 255, 255, 0.35);
        }

        /* 🔥 Button */
        .btn-custom {
            background: linear-gradient(135deg, #4f46e5, #6366f1);
            border: none;
            border-radius: 12px;
            padding: 12px 26px;
            font-weight: 600;
            color: #fff;
            transition: all 0.3s ease;
            box-shadow: 0 10px 25px rgba(79, 70, 229, 0.4);
        }

        .btn-custom:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 35px rgba(79, 70, 229, 0.6);
        }

        /* 🔗 Links */
        .forgot-link {
            font-size: 0.9rem;
            color: #fff;
            opacity: 0.85;
            transition: opacity 0.3s;
        }

        .forgot-link:hover {
            opacity: 1;
        }

        label {
            font-weight: 500;
        }
    </style>
</head>

<body>

    <!-- Floating Shapes -->
    <div class="shape one"></div>
    <div class="shape two"></div>

    <div class="login-card">
        <div class="text-center mb-4">
            <h3>Welcome Back 👋</h3>
            <p>Login to your admin dashboard</p>
        </div>

        <?php if(session('status')): ?>
            <div class="alert alert-success mb-3">
                <?php echo e(session('status')); ?>

            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('login')); ?>">
            <?php echo csrf_field(); ?>

            <div class="mb-3">
                <label>Email Address</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="bi bi-envelope-fill"></i></span>
                    <input type="email" name="email" class="form-control" placeholder="Enter your email" required>
                </div>
            </div>

            <div class="mb-3">
                <label>Password</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="bi bi-lock-fill"></i></span>
                    <input type="password" name="password" class="form-control" placeholder="Enter your password"
                        required>
                </div>
            </div>

            <div class="form-check mb-4">
                <input type="checkbox" class="form-check-input" id="remember_me" name="remember">
                <label class="form-check-label" for="remember_me">Remember me</label>
            </div>

            <div class="d-flex justify-content-between align-items-center">
                <a href="<?php echo e(route('password.request')); ?>" class="forgot-link text-decoration-none">
                    Forgot password?
                </a>
                <button class="btn btn-custom">Login</button>
            </div>
        </form>
    </div>

</body>

</html>
<?php /**PATH C:\Users\Himel\Herd\nathanielshell_laravel\resources\views/welcome.blade.php ENDPATH**/ ?>